# Eleventh International Obfuscated C Code Contest

View the `index.html` web page for the given winning entry for information on how
on how to compile it and how to run the winning program.
Look at the winning source and try to figure how it does what it does!
You may then wish to look at the Author's remarks for even more details.

Name and address information are separated from the actual program
prior to judging.  This eliminates any chance that we would bias our
judging for/against any person or group.

This year we retracted the guideline that discouraged the use of C
constructs such as `3["curds"]`.  At one time, certain ANSI compilers did
not consider such expressions to be valid ANSI C.  Alert readers noted
that the current ANSI standard considered them to be valid.  We were
unable to find an ANSI C compiler that flagged such expressions as
errors.

Rule abuse was encouraged this year - two of this year's winning entries found
new and interesting abuses of the [rules](rules.txt). [Next year's
rules](../1995/rules.txt) will change due to these ([smr](smr/index.html) and
[dodsond2](dodsond2/index.html)) entries' forms of abuse.


## Want to be an IOCCC Judge?

We are thinking about adding a 3rd judge to our team.  A 3rd judge
would help distribute the work load as well as to allowing us to
possibly expand or reshape the contest.

The ideal 3rd judge would have all of the following:

* thorough knowledge of the C language (ANSI and K&R)
* thorough knowledge of common C libs (libc, libm, curses, ...)
* reasonable written communication skills (able to write `README.md` files, for example)
* appreciation for well-written non-obfuscated code
* willing to devote ~4 weekend days in January (starting Jan 96) for judging
* located in the San Francisco (California, US) Bay Area, or
  able to travel (paying your own way) to the SF Bay Area during judging, or
  able to link to the other IOCCC judges by some form of a video link

Any of the following, though not required, would be a plus:

* familiar with portability issues
* some `/bin/sh` experience
* some Perl experience
* some C++ experience
* some experience with low-level X11 programming
* attends USENIX conferences on a regular basis
* good sense of humor
* loves chocolate and other fine foods  :-)

If you think this may be you, send an email before 31 Dec 1995, to:

```
    judges@toad.com             (use the Subject: 3rd judge)
```

Include in your message:

* Your name, address, email address and phone number
* Why would you want to be an IOCCC judge?
* How well do you match each of the above qualifications?
* What special skills would you bring to the team?

If you have any questions about the above, feel free to ask us via
email at the above address.


## Looking for an IOCCC WWW site

We would like to setup an IOCCC home page somewhere out in WWW land.
If you have a well known stable site that would be willing to give us
access to put up some IOCCC html pages, please send an email (say prior
to 31 Dec 1995) to:

```
    judges@toad.com             (use the Subject: www site)
```

describing your site and any other appropriate comments.  Thanks!


## A few notes regarding future contests

Due to changes in the USENIX conference calendar, the 1995 contest will
be delayed.  Because there will be no Summer 1995 USENIX conference,
the 1995 IOCCC entries will be announced at the Jan 1996 USENIX conference.

The 1995 contest will not open until late October 1995, and will close
sometime around the end of December 1995.  The rules for the 1995
contest have not been formed at this time and are not expected to be
ready for distribution until late October 1995.

Be sure to wait until the 1995 rules are posted before submitting entries.
Rules differ from year to year, sometimes in significant ways.

Please send us comments and suggestions what we have expressed above.
Also include anything else that you would like to see in future contests.
See [How to contact the IOCCC](../contact.html) for how to provide
us with your comments and suggestions today.

For those who appreciate a bit of Internet history, this is how
people used to contact the IOCCC in this given year, via [Unix to Unix CoPy
&lpar;UUCP&rpar;](https://en.wikipedia.org/wiki/UUCP#Mail_routing):

>   ...!{sun,pacbell,uunet,pyramid}!hoptoad!judges<br>
>   judges@toad.com

If you use, distribute or publish these entries in some way, please drop
us a line.  We enjoy seeing who, where and how the contest is used,
as well as details on how to provide fixes to any of the entries.


## Final Comments

**IMPORTANT NOTE**: The email addresses found above are for historical
purposes only, and should not be used today.  See
[contact.html](../contact.html) for up to date contact details
as well as details on how to provide fixes to any of the entries.
See also the [IOCCC FAQ](../faq.html) for additional information on the IOCCC.


## Credits

We would like to thank Barbara Frezza for her role as official chef
of the contest.  Landon Curt Noll and Larry Bassel appreciated the opportunity
to serve as official taste testers.  And as usual, the food was excellent.
The official menu of the [1994 Obfuscated C Contest](index.html) dinner:

**Antipasto**: meats, cheeses, olives, peppers, pickles, artichokes<br>
**Soup**: Cream of tomato<br>
**Salad**: spring mix<br>
**Pasta**: Linguine with wild mushrooms and Reggiano Parmesan<br>
**Seafood**: Salmon in cream sauce or lobster claws<br>
**Vegetable**: Zucchini<br>
**Dessert**: Homemade chocolate/pecan brownies, fruit<br>


<!--

    Copyright © 1984-2024 by Landon Curt Noll. All Rights Reserved.

    You are free to share and adapt this file under the terms of this license:

        Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)

    For more information, see:

        https://creativecommons.org/licenses/by-sa/4.0/

-->
